/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.FluidMixerRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FluidMixerRecipeImpl
extends FluidMixerRecipe {
    private final FluidIngredient input1;
    private final FluidIngredient input2;
    private final FluidStack outputFluid;
    private final ItemStack outputItem;
    private final float pressure;
    private final int processingTime;

    public FluidMixerRecipeImpl(ResourceLocation id, FluidIngredient input1, FluidIngredient input2, FluidStack outputFluid, ItemStack outputItem, float pressure, int processingTime) {
        super(id);
        this.input1 = input1;
        this.input2 = input2;
        this.outputFluid = outputFluid;
        this.outputItem = outputItem;
        this.pressure = pressure;
        this.processingTime = processingTime;
    }

    @Override
    public boolean matches(FluidStack fluid1, FluidStack fluid2) {
        return this.input1.testFluid(fluid1) && this.input2.testFluid(fluid2) || this.input2.testFluid(fluid1) && this.input1.testFluid(fluid2);
    }

    @Override
    public FluidIngredient getInput1() {
        return this.input1;
    }

    @Override
    public FluidIngredient getInput2() {
        return this.input2;
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    @Override
    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public float getRequiredPressure() {
        return this.pressure;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.input1.m_43923_(buffer);
        this.input2.m_43923_(buffer);
        this.outputFluid.writeToPacket(buffer);
        buffer.m_130055_(this.outputItem);
        buffer.writeFloat(this.pressure);
        buffer.m_130130_(this.processingTime);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.FLUID_MIXER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.FLUID_MIXER.get();
    }

    public static class Serializer<T extends FluidMixerRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input1 = FluidIngredient.m_43917_((JsonElement)json.get("input1"));
            Ingredient input2 = FluidIngredient.m_43917_((JsonElement)json.get("input2"));
            FluidStack outputFluid = json.has("fluid_output") ? ModCraftingHelper.fluidStackFromJson(json.getAsJsonObject("fluid_output")) : FluidStack.EMPTY;
            ItemStack outputItem = json.has("item_output") ? ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"item_output")) : ItemStack.f_41583_;
            float pressure = GsonHelper.m_13915_((JsonObject)json, (String)"pressure");
            int processingTime = GsonHelper.m_13824_((JsonObject)json, (String)"time", (int)200);
            return this.factory.create(recipeId, (FluidIngredient)input1, (FluidIngredient)input2, outputFluid, outputItem, pressure, processingTime);
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            FluidIngredient input1 = (FluidIngredient)Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidIngredient input2 = (FluidIngredient)Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidStack outputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            ItemStack outputItem = buffer.m_130267_();
            float pressure = buffer.readFloat();
            int processingTime = buffer.m_130242_();
            return this.factory.create(recipeId, input1, input2, outputFluid, outputItem, pressure, processingTime);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends FluidMixerRecipe> {
            public T create(ResourceLocation var1, FluidIngredient var2, FluidIngredient var3, FluidStack var4, ItemStack var5, float var6, int var7);
        }
    }
}

